/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionHelpers;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.Restriction;
import jeresources.util.MapKeys;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WorldGenEntry {
    private float[] chances;
    private boolean silktouch;
    private ItemStack block;
    private int minY;
    private int maxY;
    private int colour;
    private Restriction restriction;
    private DistributionBase distribution;
    private Map<String, Set<LootDrop>> drops;
    private Map<Item, Set<LootDrop>> wildcardDrops;
    private Map<String, ItemStack> dropsDisplay;

    public WorldGenEntry(ItemStack block, DistributionBase distribution, Restriction restriction, boolean silktouch, LootDrop ... drops) {
        this.block = block;
        this.distribution = distribution;
        this.restriction = restriction;
        this.colour = -16777216;
        this.silktouch = silktouch;
        this.drops = new HashMap<String, Set<LootDrop>>();
        this.wildcardDrops = new HashMap<Item, Set<LootDrop>>();
        this.dropsDisplay = new HashMap<String, ItemStack>();
        this.addDrops(drops);
        this.calcChances();
    }

    public WorldGenEntry(ItemStack block, DistributionBase distribution, LootDrop ... drops) {
        this(block, distribution, Restriction.OVERWORLD, false, drops);
    }

    public WorldGenEntry(ItemStack block, DistributionBase distribution, boolean silktouch, LootDrop ... drops) {
        this(block, distribution, Restriction.OVERWORLD, silktouch, drops);
    }

    public WorldGenEntry(ItemStack block, DistributionBase distribution, Restriction restriction, LootDrop ... drops) {
        this(block, distribution, restriction, false, drops);
    }

    public void addDrops(LootDrop ... drops) {
        for (LootDrop drop : drops) {
            String mapKey = MapKeys.getKey(drop.item);
            if (mapKey == null) continue;
            Set<LootDrop> dropSet = this.drops.get(mapKey);
            if (dropSet == null) {
                dropSet = new TreeSet<LootDrop>();
            }
            dropSet.add(drop);
            this.drops.put(mapKey, dropSet);
            if (this.dropsDisplay.containsKey(mapKey)) continue;
            ItemStack itemStack = drop.item.func_77946_l();
            itemStack.func_190920_e(Math.max(1, drop.minDrop));
            this.dropsDisplay.put(mapKey, itemStack);
        }
    }

    public void addDrops(Collection<LootDrop> drops) {
        this.addDrops(drops.toArray(new LootDrop[drops.size()]));
    }

    private void calcChances() {
        this.chances = new float[256];
        this.minY = 256;
        this.maxY = 0;
        int i = -1;
        for (float chance : this.distribution.getDistribution()) {
            if (++i == this.chances.length) break;
            int n = i;
            this.chances[n] = this.chances[n] + chance;
            if (!(this.chances[i] > 0.0f)) continue;
            if (this.minY > i) {
                this.minY = i;
            }
            if (i <= this.maxY) continue;
            this.maxY = i;
        }
        if (this.minY == 256) {
            this.minY = 0;
        }
        if (this.maxY == 0) {
            this.maxY = 255;
        }
        this.minY = this.minY < 128 ? 0 : 128;
        this.maxY = this.maxY <= 127 ? 127 : 255;
    }

    public float[] getChances() {
        return Arrays.copyOfRange(this.chances, this.minY, this.maxY + 1);
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public boolean isSilkTouchNeeded() {
        return this.silktouch;
    }

    public int getColour() {
        return this.colour;
    }

    public List<ItemStack> getDrops() {
        return new ArrayList<ItemStack>(this.dropsDisplay.values());
    }

    public List<ItemStack> getBlockAndDrops() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        list.add(this.block);
        list.addAll(this.getDrops());
        return list;
    }

    public ItemStack getBlock() {
        return this.block;
    }

    public List<String> getBiomeRestrictions() {
        return this.restriction.getBiomeRestrictions();
    }

    public String getDimension() {
        return this.restriction.getDimensionRestriction();
    }

    public List<LootDrop> getLootDrops(ItemStack itemStack) {
        String key = MapKeys.getKey(itemStack);
        ArrayList<LootDrop> list = new ArrayList<LootDrop>(this.drops.containsKey(key) ? (Collection)this.drops.get(key) : (Collection)this.wildcardDrops.get(itemStack.func_77973_b()));
        Collections.reverse(list);
        return list;
    }

    public float getAverageBlockCountPerChunk() {
        float sum = 0.0f;
        for (float chance : this.chances) {
            sum += chance;
        }
        return (float)Math.round(sum * (float)this.chances.length * 100.0f) / 100.0f;
    }

    public String toString() {
        return "WorldGenEntry: " + this.block.func_151000_E() + " - " + this.restriction.toString();
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public void merge(WorldGenEntry entry) {
        entry.drops.values().forEach(this::addDrops);
        this.distribution = DistributionHelpers.addDistribution(this.distribution, entry.distribution);
        this.calcChances();
    }
}

